!function() {
    
    //Raises the energy bar's maximum to 20
    Object.defineProperty(Game_Party.prototype, 'stressEnergyCount', {get: function() {return this._stressEnergyCount;}, set: function (value) {this._stressEnergyCount = value.clamp(0, 20);}, configurable: true});

    
    //Makes sure the energy bar can be properly displayed avec 10
    let old_Sprite_StressBar_prototype_drawStressCountValue = Sprite_StressBar.prototype.drawStressCountValue;
    Sprite_StressBar.prototype.drawStressCountValue = function (value = this._ekgRow) {
        if ($gameTroop._troopId == 451) {
		  //Work normally
          this._ekgText.bitmap.clear();
          // Refresh EKG Bitmap
          this._ekgText.bitmap.drawText(value.clamp(0, 10).padZero(2), 0, -4, this._ekgText.bitmap.width, this._ekgText.bitmap.height, 'center');
          return;
        }
        // Clear Text
        this._ekgText.bitmap.clear();
        // Refresh EKG Bitmap
        this._ekgText.bitmap.drawText(value.clamp(0, 20).padZero(2), 0, -4, this._ekgText.bitmap.width, this._ekgText.bitmap.height, 'center');
    };

    //Properly displays the RELEASE ENERGY bubble
    Window_OmoriBattleActorStatus.prototype.setupACSBubbles = function (list) {
        // Get Actor
        var actor = this.actor();
        this._lastACSList = list;
        for (var i = 0; i < this._acsBubbleSprites.length; i++) {
            // Get Skill
            var data = list[i];
            // Get Bubble
            var bubble = this._acsBubbleSprites[i];
            // Update Position
            bubble.updatePosition(i);
            // If Data
            if (data) {
                // Get Skill
                var skill = data[1];
                // Bubble Index
                var bubbleIndex = skill.meta.ChainSkillIcon === undefined ? 0 : Number(skill.meta.ChainSkillIcon);
                // If Skill is Chain Skill Energy Release And Energy is at max
                if (skill.meta.ChainSkillEnergyRelease && $gameParty.stressEnergyCount >= 20) {
                    // Change Index
                    bubbleIndex = $gameParty.size() === 1 ? 3 : 2;
                    bubble.startShake();
                } else {
                    bubble.stopShake();
                }
                ;
                // Set Bubble Index
                bubble.setBubbleIndex(bubbleIndex);
                bubble.setArrowDirection(data[0]);
                actor.canUse(skill) ? bubble.activate() : bubble.deactivate();
            }
            ;
        }
        ;
    };

    Window_OmoriBattleActorStatus.prototype.updateACSBubbleStatus = function() {
        let actor = this.actor()
        if (this._lastACSList) {
          for (const [i, bubble] of this._acsBubbleSprites.entries()) {
            let data = this._lastACSList[i]
            if (data) {
              let skill = data[1]
              actor.canUse(skill) ? bubble.activate() : bubble.deactivate()
            }
          }
        }
      }
      Window_BattleStatus.prototype.refreshACS = function() {
        for (const win of this._faceWindows) {
          win.updateACSBubbleStatus()
        }
      }
    
	// Double the values that the energy bar background changes at
    let old_Sprite_StressBar_prototype_updateBackgroundImage = Sprite_StressBar.prototype.updateBackgroundImage
    Sprite_StressBar.prototype.updateBackgroundImage = function() {
      // Get Background Name
      let backgroundName = 'StressBar_DreamWorld';
      // Set Index to 0
      let index = 0;
      // Set Default Rows
      let rows = 5;
      // Get Stress
      let stress = $gameParty.stressEnergyCount;

      if ($gameParty.actorIsAffectedByState(1, 20) || $gameParty.actorIsAffectedByState(8, 20)) {
        stress = 10;
      }

      switch ($gameVariables.value(22)) {
        case 1:
		  //Changed from 4/0/16 to 8/0/16
          index = Math.min(Math.max(Math.floor(stress / 8), 0), 16);
        break;
        case 3:
        case 4:
          backgroundName = 'StressBar_BlackSpace';
          rows = 4;
          if (stress === 10) {
            index = 2;
          } else if (stress > 6 && stress < 10) {
            index = 2;
          } else if (stress > 3 && stress <= 6) {
            index = 1;
          } else {
            index = 0;
          };
        break;
      };
      // Get Bitmap
      let bitmap = ImageManager.loadSystem(backgroundName);
      // Get Height
      let height = bitmap.height / rows;
      // Set Background Bitmap
      this._background.bitmap = bitmap;
      // Set Background Frame
      bitmap.addLoadListener(() => this._background.setFrame(0, index * height, bitmap.width, height));
    };
    
	//Fix the energy line not being shown when energy is above 11
    let old_Sprite_StressBar_prototype_refreshEKGBitmap = Sprite_StressBar.prototype.refreshEKGBitmap;
    Sprite_StressBar.prototype.refreshEKGBitmap = function(index = this._ekgRow) {
      
	  let energy = $gameParty.stressEnergyCount;
	  
      let ekgName = 'energy_stress_ekg_line';
      switch ($gameVariables.value(22)) {
        case 1: ekgName = 'energy_dw_line' ;break;
        case 3: ekgName = 'energy_stress_ekg_line' ;break;
        case 4: ekgName = 'energy_stress_ekg_line' ;break;
      };
      // Get Bitmap
      var bitmap = ImageManager.loadSystem(ekgName);
	  // Clear & Transfer Bitmap
      this._ekgLineBitmap.clear();
	  // If the player is fighting BASIL, work normally
      if ($gameTroop._troopId == 451) {
        this._ekgLineBitmap.blt(bitmap, 0, index * 28, bitmap.width, 28, 0, 0);
      } else {
		// Check if the energy value is odd or even
		if (energy % 2) { 
			// If the energy value is odd, move the index
		    this._ekgLineBitmap.blt(bitmap, 0, (index * 14) - 14, bitmap.width, 28, 0, 0);
		} else {
            this._ekgLineBitmap.blt(bitmap, 0, index * 14, bitmap.width, 28, 0, 0);
		}
      }
      // If Pending EKG Row is valid
	  if (this._pendingEKGRow >= 0) {
        this._ekgLineNewBitmap.clear()
        this._ekgLineNewBitmap.blt(bitmap, 0, this._pendingEKGRow * 28, bitmap.width, 28, 0, 0);
      };
    };
    
	//Fix the energy box being blank at the start of a fight
    let old_Sprite_StressBar_prototype_update = Sprite_StressBar.prototype.update;
    Sprite_StressBar.prototype.update = function() {
      // Super Call
      Sprite.prototype.update.call(this);

      // Determine if stressed
      let stressed = $gameParty.actorIsAffectedByState(1, 20) || $gameParty.actorIsAffectedByState(8, 20);
      // Get Energy
      let energy = $gameParty.stressEnergyCount;

      // If Stressed Set energy to 20
      if (stressed) { energy = 10; }

      // Increase Frame Count
      this._frameCount = (this._frameCount + 1) % 60;

      // If Energy does not match ekg row
      if (energy !== this._ekgRow) {
        // If energy is at max and troop is 415
        if (energy === 10 && $gameTroop._troopId === 451) {
          // Set Pending EKG row to 11
          this._pendingEKGRow = 11;
        } else {
          // Set Pending EKG Row to match energy
          this._pendingEKGRow = energy;
        };

        // Update Background Image
        this.updateBackgroundImage();
        // Draw stress Count value
        if(!stressed) {this.drawStressCountValue(energy);}

      };
	  
	  //Fix the energy box being blank at the start of a fight
	  if (!stressed && energy == 0) { this.drawStressCountValue(0); };

      // If frame count is 0
      if (this._frameCount && this._frameCount % BattleManager._stressSpeed === 0) {
        // If Stressed
        if (stressed) {
          // Draw Stress Count Value
          this.drawStressCountValue(Math.randomInt(11));
        }
      }

      // Update Line
      this.updateLine(stressed)
    };
    
}()